/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.debug.core.DebugOptionsManager;
import com.aptana.js.debug.core.model.JSDebugModel;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.Messages;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public final class WorkbenchCloseListener
implements Listener {
    private WorkbenchCloseListener() {
    }

    public void handleEvent(Event event) {
        if (event.widget instanceof Shell && PlatformUI.getWorkbench().getWorkbenchWindowCount() == 1 && PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell().equals(event.widget)) {
            String modelIdentifier = JSDebugModel.getModelIdentifier();
            boolean debuggerActive = DebugOptionsManager.isDebuggerActive((String)modelIdentifier);
            boolean profilerActive = DebugOptionsManager.isProfilerActive((String)modelIdentifier);
            if (debuggerActive || profilerActive) {
                IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.aptana.js.debug.ui");
                if (!preferences.getBoolean("com.aptana.js.debug.ui.confirm_exit_debugger", true)) {
                    return;
                }
                event.doit = false;
                MessageDialogWithToggle dlg = debuggerActive ? MessageDialogWithToggle.openOkCancelConfirm((Shell)((Shell)event.widget), (String)Messages.WorkbenchCloseListener_ConfirmDebuggerExit, (String)Messages.WorkbenchCloseListener_DebuggerIsActive_DoYouWantToExit, (String)Messages.WorkbenchCloseListener_AlwaysExitDebuggerWithoutPrompt, (boolean)false, null, null) : MessageDialogWithToggle.openOkCancelConfirm((Shell)((Shell)event.widget), (String)Messages.WorkbenchCloseListener_ConfirmProfilerExit, (String)Messages.WorkbenchCloseListener_ProfilerIsActive_DoYouWantToExit, (String)Messages.WorkbenchCloseListener_AlwaysExitProfilerWithoutPrompt, (boolean)false, null, null);
                int returnValue = dlg.getReturnCode();
                if (returnValue != 0) {
                    event.type = 0;
                    return;
                }
                if (dlg.getToggleState()) {
                    preferences.putBoolean("com.aptana.js.debug.ui.confirm_exit_debugger", false);
                    try {
                        preferences.flush();
                    }
                    catch (BackingStoreException e) {
                        IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        }
    }

    public static void init() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                Display.getCurrent().addFilter(21, (Listener)new WorkbenchCloseListener(null));
            }
        });
    }

    /* synthetic */ WorkbenchCloseListener(WorkbenchCloseListener workbenchCloseListener) {
        this();
    }
}

